IF OBJECT_ID('PG_FORN_ORCAMENTO_COMPRAS_APORTE') IS NULL
begin
CREATE TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FORN] [int] NOT NULL,
	[DT_MOV] [datetime] NOT NULL,
	[VLR_ORCAMENTO_APORTE] [money] NOT NULL,
	[CD_HIST] [int] NOT NULL,
	[CPL_HIST] [varchar](500) NOT NULL,
 CONSTRAINT [PK_PG_FORN_ORCAMENTO_COMPRAS_APORTE] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_PG_FORN_ORCAMENTO_COMPRAS_APORTE] UNIQUE NONCLUSTERED 
(
	[CD_FORN] ASC,
	[DT_MOV] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE] ADD  CONSTRAINT [DF_PG_FORN_ORCAMENTO_COMPRAS_APORTE_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE] ADD  CONSTRAINT [DF_PG_FORN_ORCAMENTO_COMPRAS_APORTE_CD_FORN]  DEFAULT ((0)) FOR [CD_FORN]

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE] ADD  CONSTRAINT [DF_PG_FORN_ORCAMENTO_COMPRAS_APORTE_DT_MOV]  DEFAULT (getdate()) FOR [DT_MOV]

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE] ADD  CONSTRAINT [DF_PG_FORN_ORCAMENTO_COMPRAS_APORTE_VLR_ORCAMENTO_APORTE]  DEFAULT ((0)) FOR [VLR_ORCAMENTO_APORTE]

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE] ADD  CONSTRAINT [DF_PG_FORN_ORCAMENTO_COMPRAS_APORTE_CD_HIST]  DEFAULT ((0)) FOR [CD_HIST]

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE] ADD  CONSTRAINT [DF_PG_FORN_ORCAMENTO_COMPRAS_APORTE_COMPLEMENTO_HIST]  DEFAULT ('') FOR [CPL_HIST]

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE]  WITH CHECK ADD  CONSTRAINT [FK_PG_FORN_ORCAMENTO_COMPRAS_APORTE_CTB_HIST] FOREIGN KEY([CD_EMP], [CD_HIST])
REFERENCES [dbo].[CTB_HIST] ([CD_EMP], [CD_HIST])

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE] CHECK CONSTRAINT [FK_PG_FORN_ORCAMENTO_COMPRAS_APORTE_CTB_HIST]

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE]  WITH CHECK ADD  CONSTRAINT [FK_PG_FORN_ORCAMENTO_COMPRAS_APORTE_PG_FORN] FOREIGN KEY([CD_EMP], [CD_FORN])
REFERENCES [dbo].[PG_FORN] ([CD_EMP], [CD_FORN])

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE] CHECK CONSTRAINT [FK_PG_FORN_ORCAMENTO_COMPRAS_APORTE_PG_FORN]

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE]  WITH CHECK ADD  CONSTRAINT [FK_PG_FORN_ORCAMENTO_COMPRAS_APORTE_PG_FORN_ORCAMENTO_COMPRAS] FOREIGN KEY([CD_EMP], [CD_FORN])
REFERENCES [dbo].[PG_FORN_ORCAMENTO_COMPRAS] ([CD_EMP], [CD_FORN])

ALTER TABLE [dbo].[PG_FORN_ORCAMENTO_COMPRAS_APORTE] CHECK CONSTRAINT [FK_PG_FORN_ORCAMENTO_COMPRAS_APORTE_PG_FORN_ORCAMENTO_COMPRAS]
end

